IF EXISTS( SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_VD_PROC_ALL]')
		  AND type IN(N'P', N'PC')
)
	DROP PROCEDURE [dbo].[P_EST_PROD_VD_PROC_ALL];
GO
--EXEC P_EST_PROD_VD_PROC_ALL 0,1
CREATE PROCEDURE P_EST_PROD_VD_PROC_ALL @TIPO_PROC INT=0,@FLAG_DT_ATUAL INT=0, @PrintDebug tinyint=0
/*
	0 - Todos os movimentos
	1 - Somente Vendas
	2 - Somente Entrada
	3 - Somente consolidacao dos produtos
*/
AS
	 
	SET NOCOUNT ON;
	DECLARE @CD_EMP INT;
	DECLARE @CD_FILIAL INT;
	DECLARE @DT_VD DATETIME;
	DECLARE @CD_CTR BIGINT;
	DECLARE @DT_PROC DATETIME;

	BEGIN TRY

		if @PrintDebug > 0
		begin
			PRINT 'P_ADM_ERRO_PDV_VD_INTEGRACOES_REPROCESSAR'
		end

		EXEC P_ADM_ERRO_PDV_VD_INTEGRACOES_REPROCESSAR
		
		SET @DT_PROC = convert (date,getdate())
	
		if @PrintDebug > 0
			PRINT 'P_EST_PROD_VD_PROC_ALL - INSERT 1 '+CONVERT(VARCHAR, GETDATE(), 108);

		CREATE TABLE #RsProdcCplPend(CD_CTR BIGINT, DT_MOV DATETIME, ANO_MES INT);
		
		IF @FLAG_DT_ATUAL=0 
		begin

			if @PrintDebug > 0
				PRINT 'Rodar mes atual '+CONVERT(VARCHAR, GETDATE(), 108);
			
			
			INSERT INTO #RsProdcCplPend
				SELECT distinct
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR_DT_MOVIMENTO,
					GLB_DT_MOVIMENTO.DT_MOVIMENTO,
					GLB_DT_MOVIMENTO.ANO_MES_MOVIMENTO
				FROM 
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE 
					INNER JOIN GLB_DT_MOVIMENTO ON
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
				WHERE
					GLB_DT_MOVIMENTO.DT_MOVIMENTO = @DT_PROC 
				 
				UPDATE 
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE
				SET
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.DT_PROC=NULL,
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.DT_PROC_FIM=NULL,
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.DT_PROD_FILIAL_ANO_MES=NULL,
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.DT_PROD_REDE_ANO_MES=NULL, 
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.FILIAL_PROC=0
				FROM 
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE INNER JOIN GLB_DT_MOVIMENTO ON
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
				WHERE
					GLB_DT_MOVIMENTO.DT_MOVIMENTO = @DT_PROC
		end

		IF @FLAG_DT_ATUAL=1 
		begin

			if @PrintDebug > 0
				PRINT 'Rodar outros meses '+CONVERT(VARCHAR, GETDATE(), 108);


			INSERT INTO #RsProdcCplPend
				SELECT distinct
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR_DT_MOVIMENTO,
					GLB_DT_MOVIMENTO.DT_MOVIMENTO,
					GLB_DT_MOVIMENTO.ANO_MES_MOVIMENTO
				FROM 
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE INNER JOIN GLB_DT_MOVIMENTO ON
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
				WHERE
					GLB_DT_MOVIMENTO.DT_MOVIMENTO < @DT_PROC
				
				UPDATE 
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE
				SET
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.DT_PROC=NULL,
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.DT_PROC_FIM=NULL,
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.DT_PROD_FILIAL_ANO_MES=NULL,
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.DT_PROD_REDE_ANO_MES=NULL, 
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.FILIAL_PROC=0
				FROM 
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE INNER JOIN GLB_DT_MOVIMENTO ON
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
				WHERE
					GLB_DT_MOVIMENTO.DT_MOVIMENTO < @DT_PROC
		end

		IF @TIPO_PROC IN (0,1)
		BEGIN
			 if @PrintDebug > 0
				PRINT 'SELECT 2 '+CONVERT(VARCHAR, GETDATE(), 108);


			 DECLARE ProcMovResumo CURSOR FAST_FORWARD
			 FOR 
				SELECT DISTINCT
					P.CD_CTR_DT_MOVIMENTO
					, 1 AS CD_EMP
					, pend.DT_MOV
					, f.CD_FILIAL
				FROM
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE p
					JOIN EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL f ON p.CD_CTR = f.CD_CTR
					INNER JOIN #RsProdcCplPend pend ON p.CD_CTR_DT_MOVIMENTO = pend.CD_CTR
				ORDER BY pend.DT_MOV DESC;

			OPEN ProcMovResumo;
			FETCH NEXT FROM ProcMovResumo INTO @CD_CTR, @CD_EMP, @DT_VD, @CD_FILIAL ;

			WHILE @@FETCH_STATUS = 0
				BEGIN

					if @PrintDebug > 0
					begin 
						PRINT 'Movimento vendas DATA '+CONVERT(VARCHAR, @DT_VD, 112) + ' Filial ' + CONVERT(VARCHAR, @CD_FILIAL);
						PRINT 'UPDATE 3 '+CONVERT(VARCHAR, GETDATE(), 108);
					end

					UPDATE  P
					SET DT_PROC=GETDATE()
					FROM
						EST_PROD_CPL_VD_LOTE_PROC_PENDENTE p
						JOIN EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL f ON 
							p.CD_CTR = f.CD_CTR
					WHERE	
						CD_CTR_DT_MOVIMENTO=@CD_CTR
						AND F.CD_FILIAL =@CD_FILIAL;

					IF @TIPO_PROC IN (0,1)
					BEGIN
						 if @PrintDebug > 0
						 begin 
							PRINT 'EXEC 4 '+CONVERT(VARCHAR, GETDATE(), 108);
						 end				
						 		 
						 EXEC P_EST_MOVIMENTO_VENDAS @CD_EMP, @DT_VD, @CD_FILIAL ;
					END
					 
					UPDATE  P
					SET
						DT_PROC_FIM=GETDATE()
					FROM
						EST_PROD_CPL_VD_LOTE_PROC_PENDENTE p
						JOIN EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL f ON p.CD_CTR = f.CD_CTR
					WHERE
						CD_CTR_DT_MOVIMENTO =@CD_CTR
						AND CD_EMP =1
						AND CD_FILIAL = @CD_FILIAL


					FETCH NEXT FROM ProcMovResumo INTO @CD_CTR ,	@CD_EMP , @DT_VD, @CD_FILIAL;
				 END;

			 CLOSE ProcMovResumo;
			 DEALLOCATE ProcMovResumo;
		end

/******************************************************************************************************************/
	SET @CD_FILIAL =0;

	IF @TIPO_PROC IN (0,2)
	begin
		
		DECLARE ProcMovResumo CURSOR FAST_FORWARD
		FOR 
		SELECT DISTINCT
			1 AS CD_EMP
			, pend.DT_MOV 
		FROM
			EST_PROD_CPL_VD_LOTE_PROC_PENDENTE p 
			INNER JOIN #RsProdcCplPend pend ON 
				p.CD_CTR_DT_MOVIMENTO = pend.CD_CTR
		ORDER BY pend.DT_MOV DESC;

		OPEN ProcMovResumo;
		FETCH NEXT FROM ProcMovResumo INTO @CD_EMP, @DT_VD;

		WHILE @@FETCH_STATUS = 0
		BEGIN
			if @PrintDebug > 0
			begin 
				PRINT 'EXEC 5 '+CONVERT(VARCHAR, GETDATE(), 108);
			end

			EXEC P_EST_MOVIMENTO_COMPRAS @CD_EMP,@DT_VD;
			
			FETCH NEXT FROM ProcMovResumo INTO @CD_EMP, @DT_VD
			 			
		end

		CLOSE ProcMovResumo;
		DEALLOCATE ProcMovResumo;

	end
	
			
	SET @CD_FILIAL =0;
/******************************************************************************************************************/
/******************************************************************************************************************/
/******************************************************************************************************************/
/******************************************************************************************************************/
/******************************************************************************************************************/
	

		IF @TIPO_PROC IN (0,3)
		begin
			if @PrintDebug > 0
			begin 
				PRINT 'SELECT 6 '+CONVERT(VARCHAR, GETDATE(), 108);
			end

			DECLARE ProcMovfiliais CURSOR FAST_FORWARD
			FOR 
			SELECT DISTINCT
					p.CD_EMP,
					p.CD_FILIAL
			FROM 
				  EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL p
				  JOIN EST_PROD_CPL_VD_LOTE_PROC_PENDENTE L ON 
				  p.CD_CTR = L.CD_CTR
				  JOIN #RsProdcCplPend pend ON 
				  L.CD_CTR_DT_MOVIMENTO = pend.CD_CTR
			ORDER BY 
				p.CD_FILIAL	 
			 
			OPEN ProcMovfiliais;
			FETCH NEXT FROM ProcMovfiliais INTO @CD_EMP, @CD_FILIAL;
			
			WHILE @@FETCH_STATUS = 0
				BEGIN
					if @PrintDebug > 0
					begin 
						PRINT 'EXEC 7 '+CONVERT(VARCHAR, GETDATE(), 108);
						PRINT 'FILIAL.: '+CONVERT(VARCHAR, @CD_FILIAL, 10) + ' CONSOLIDACAO PRODUTOS ' + CONVERT(VARCHAR, @DT_VD, 112);;
					end

					EXEC P_EST_PROD_CPL_VD_PROC  @CD_EMP
												, @CD_FILIAL
												, @FLAG_DT_ATUAL;

					FETCH NEXT FROM ProcMovfiliais INTO @CD_EMP , @CD_FILIAL;
				END;

			CLOSE ProcMovfiliais;
			DEALLOCATE ProcMovfiliais;

			if @PrintDebug > 0
			begin 
				PRINT 'EXEC 8 '+CONVERT(VARCHAR, GETDATE(), 108);
			end

			EXEC P_EST_PROD_VD_PROC @FLAG_DT_ATUAL;
		end


/******************************************************************************************************************/
/******************************************************************************************************************/
/******************************************************************************************************************/


		UPDATE 
			EST_PROD_CPL_VD_LOTE_PROC_PENDENTE
		SET
			EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.DT_PROC=NULL,
			EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.DT_PROC_FIM=NULL,
			EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.DT_PROD_FILIAL_ANO_MES=NULL,
			EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.DT_PROD_REDE_ANO_MES=NULL, 
			EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.FILIAL_PROC=0
		FROM 
			EST_PROD_CPL_VD_LOTE_PROC_PENDENTE INNER JOIN #RsProdcCplPend P ON
			EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.ANO_MES = p.ANO_MES  
	
	--Deletando produtos da pendencia
		DECLARE @TotalLinhas BIGINT, 
				@LoteExclusao BIGINT, 
				@Contador BIGINT, 
				@TotalLotes BIGINT;

		SET @TotalLinhas =  ISNULL((SELECT COUNT(*)
									FROM #RsProdcCplPend pend
										 INNER JOIN EST_PROD_CPL_VD_LOTE_PROC_EST_PROD p
										 ON pend.CD_CTR = p.CD_CTR ),0)
		SET @LoteExclusao = 100000
		SET @Contador = 1
		SET @TotalLotes = (@TotalLinhas / @LoteExclusao) + 1

		WHILE @Contador <= @TotalLotes
		BEGIN
			if @PrintDebug > 0
			begin 
				PRINT 'DELETE 9 '+CONVERT(VARCHAR, GETDATE(), 108);
			end

			DELETE 
				top (@LoteExclusao) P
			FROM 
				EST_PROD_CPL_VD_LOTE_PROC_EST_PROD p
				JOIN EST_PROD_CPL_VD_LOTE_PROC_PENDENTE L ON 
				  p.CD_CTR = L.CD_CTR
				JOIN #RsProdcCplPend pend ON 
				l.CD_CTR_DT_MOVIMENTO = pend.CD_CTR;
			SET @Contador = @Contador + 1
		END
		--Fim

		--Deletando cabecalho
		if @PrintDebug > 0
		begin 
			PRINT 'DELETE 10 '+CONVERT(VARCHAR, GETDATE(), 108);
		end

		DELETE 
			P
		FROM 
			EST_PROD_CPL_VD_LOTE_PROC_PENDENTE p
			INNER JOIN #RsProdcCplPend pend ON p.CD_CTR_DT_MOVIMENTO = pend.CD_CTR;
		--Fim

		--Deletando pendencia de processamento Leitura Z
		DELETE 
			PDV_CONSLD_VD_MOVIMENTO_REPROCESSAR
		FROM
			#RsProdcCplPend P INNER JOIN PDV_CONSLD_VD_MOVIMENTO_REPROCESSAR ON
			P.DT_MOV = PDV_CONSLD_VD_MOVIMENTO_REPROCESSAR.DT_MOV
		
		--Inserindo nova pendencia
		INSERT INTO PDV_CONSLD_VD_MOVIMENTO_REPROCESSAR (CD_EMP,CD_FILIAL, DT_MOV, TIPO_ORIGEM, DT_CAD )
		SELECT
			PRC_FILIAL.CD_EMP,
			PRC_FILIAL.CD_FILIAL,
			p.DT_MOV,
			'CONSOLIDACAO RELATORIOS',
			GETDATE()
		FROM 
			#RsProdcCplPend p INNER JOIN PRC_FILIAL ON
			@CD_EMP = PRC_FILIAL.CD_EMP

		DROP TABLE #RsProdcCplPend;
		
	END TRY
	
BEGIN CATCH 
	DECLARE @ErrorMessage VARCHAR(4000)=ERROR_MESSAGE();  
	DECLARE @ErrorSeverity INT=ERROR_SEVERITY();  
	DECLARE @ErrorState INT=ERROR_STATE();  

	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro )
	SELECT ERROR_NUMBER() AS numero,
			@ErrorSeverity AS severidade,
			@ErrorState AS estado,
			'P_EST_PROD_VD_PROC_ALL' AS rotina,
			ERROR_LINE() AS linha,
			@ErrorMessage AS mensagem,
			GETDATE() AS dtErro;

	RAISERROR (@ErrorMessage, 
			@ErrorSeverity,
			@ErrorState );	
	
END CATCH

PRINT 'P_EST_PROD_VD_PROC_ALL FINALIZADA!';